*> Copyright (c) 2010 by Veryant LLC. Users of isCOBOL
*> may freely modify and redistribute this program.


 program-id. jprogress.

 configuration section.
 repository.
   class event-object       as "java.util.EventObject"
   class change-event       as "javax.swing.event.ChangeEvent"
   class j-progress-bar     as "javax.swing.JProgressBar"
   class iscobol-java-bean  as "com.iscobol.gui.server.CobolGUIJavaBean".
 special-names.
   crt status is kay-status
   event object is event-obj
   event source is event-source
   .

 working-storage section.
 copy "isgui.def".
 copy "iscrt.def".
 copy "object.def".
 copy "container.def".
 copy "component.def".
 copy "jprogressbar.def".
 copy "jcomponent.def".
*>-
 77  event-obj              object reference event-object.
 77  change-evt             object reference change-event.
 77  event-source           object reference iscobol-java-bean.
 77  v-pr-bar               object reference iscobol-java-bean.
 77  h-pr-bar               object reference iscobol-java-bean.
*>-
 77  small-font             handle of font small-font.
 77  kay-status             pic 99.
 77  i                      pic 999.
 77  k                      pic 999.
 77  pb-value               pic zzz.
 77  pb-string              pic x(15).
 77  ef-val                 pic x(100).
 
 screen section.
 01 mask.
   03  java-bean 
       clsid                "javax.swing.JProgressBar"
       event-list           "change"
       line                 2 
       col                  2 
       size                 4 
       lines                20
       background-color     7
       object               v-pr-bar
       foreground-color     1
       event                pb-event
       .
   03  pb1
       push-button
       line                 2 
       col                  15
       title                "Start vertical progress" 
       size                 30
       exception-value      1
       .
   03  label  
       title                "Vertical Progress Bar value: " 
       line                 4 
       col                  15
       .
   03  lbl1 
       label 
       col                  + 1.5 
       size                 5
       .
   03  java-bean 
       clsid                "javax.swing.JProgressBar"
       event-list           "change"
       line                 25 
       col                  2 
       size                 50 
       lines                1.5
       object               h-pr-bar
       background-color rgb x#00ff11
       foreground-color rgb x#00aa00
       event                pb-event
       .
   03  pb2
       push-button 
       title                "Start horizontal progress" 
       line                 12 
       col                  15
       size                 30
       exception-value      2
       . 
   03  label  
       title                "Horizontal Progress Bar value: " 
       line                 14 
       col                  15
       .
   03  lbl2 
       label 
       col                  + 1.5 
       size                 5
       .
   03  ef1 
       entry-field 
       line                 2 
       col                  50 
       size                 25 
       lines                10
       read-only
       . 

 procedure division.
 main.
   display standard graphical window background-low lines 30
           title "Progress Bar Bean Demo"
           control font small-font.

   display mask.
   
   v-pr-bar:>setProperty("orientation" 1).
   v-pr-bar:>setProperty("borderpainted" 1).
   v-pr-bar:>setProperty("maximum" 100).
   v-pr-bar:>setProperty("minimum" 0).
   v-pr-bar:>setProperty("stringpainted" 1).

   h-pr-bar:>setProperty("orientation" 0).
   h-pr-bar:>setProperty("borderpainted" 1).
   h-pr-bar:>setProperty("maximum" 100).
   h-pr-bar:>setProperty("minimum" 0).
   h-pr-bar:>setProperty("stringpainted" 1).
               
   perform until kay-status = 27
       accept mask on exception continue
       evaluate kay-status
       when 1
          perform thread test-v-pb
       when 2
          perform thread test-h-pb
       end-evaluate
   end-perform.
    
   stop run
   .

 test-v-pb.
   modify pb1 enabled 0
   perform varying i from 10 by 10 until i > 100
      call "c$sleep" using 0.5 end-call
      v-pr-bar:>setProperty("value" i)
   end-perform
   modify pb1 enabled 1
   .

 test-h-pb.
   modify pb2 enabled 0
   perform varying k from 10 by 10 until k > 100
      call "c$sleep" using 0.5 end-call
      h-pr-bar:>setProperty("value" k)
   end-perform
   modify pb2 enabled 1
   .

 pb-event.
   if event-type = msg-jb-event
      if event-data-2 = JPROGRESSBAR-STATECHANGED
         set pb-value to event-source:>getProperty("value") 
         string pb-value "%" delimited size into pb-string
         event-source:>setProperty("string" pb-string)
         perform update-lbl             
      end-if
   end-if
   .

 update-lbl.
   set pb-value to v-pr-bar:>getProperty("value")
   modify lbl1 title pb-value
   set pb-value to  h-pr-bar:>getProperty("value")
   modify lbl2 title pb-value
   set change-evt to event-obj as change-event
   set ef-val to change-evt:>toString
   modify ef1 value ef-val
   .
      

