       *> Copyright (c) 2010 by Veryant LLC. Users of isCOBOL
       *> may freely modify and redistribute this program.

       PROGRAM-ID. tree-view.

       WORKING-STORAGE SECTION.
       copy "isgui.def".
       copy "iscrt.def".
       77  crt-status              special-names crt status pic 9(5).
       77  hWin                    handle of window.       
       77  close-win               pic 9 value 0.

       77  item-name               pic x(50).
       77  cont                    pic 9.
       77  tv-item                 unsigned-int.

       SCREEN SECTION.
       01  Mask.
           03 Tv1 
              tree-view
              buttons 
              lines-at-root
              line                 2 
              col                  2
              lines                20 
              size                 20 cells
              event                TV-EVT
              .
           03 label
              line                 10 
              col                  23 
              size                 15 cells 
              color                3
              title                "You've chosen: "
              .
           03 Lb1 
              label
              line                 10 
              col                  40 
              size                 20 cells
              .     
           03 label
              line                 12 
              col                  23 
              size                 15 cells 
              color                3
              title                "Using: "
              .
           03 Lb2 
              label
              line                 12 
              col                  40 
              size                 8 cells
              .
           03 Pb1 
              push-button
              line                 20 
              col                  23 
              title                "&Quit"
              exception-value      27
              .

       PROCEDURE DIVISION.
       MAIN.              
           display standard graphical window                   
                   background-low
                   with   system menu
                   title  "TREE-VIEW Control"
                   handle hWin
                   event  WIN-EVT

           display Mask

           perform LOAD-TREE
              
           accept  Mask until crt-status = 27 or close-win = 1
                   on exception 
                      continue
           end-accept       

           destroy Mask
           destroy hWin
           goback
           .

       LOAD-TREE.              
           perform varying cont from 1 by 1 until cont = 9
             initialize item-name
             string "Parent" cont delimited by size 
                                  into item-name
             modify Tv1 parent null 
                        item-to-add item-name giving tv-item
                        has-children 1 
             initialize item-name
             string "Child" cont delimited by size 
                                 into item-name
             modify Tv1 parent tv-item
                        item-to-add item-name giving tv-item
                        has-children 1  
             initialize item-name
             string "Child of the Child" cont delimited by size 
                                              into item-name
             modify Tv1 parent tv-item  
                        item-to-add item-name giving tv-item
                        has-children 0
           end-perform
           .
              
       TV-EVT.
           evaluate event-type 
                    when msg-tv-dblclick 
                         inquire TV1(event-data-2) item-text item-name
                         display message item-name
                    when msg-tv-selchange
                         inquire TV1(event-data-2) item-text item-name
                         modify LB1 title item-name
                         evaluate event-data-1
                                  when tvflag-mouse    
                                       modify LB2 title "mouse"
                                  when tvflag-keyboard 
                                       modify LB2 title "keyboard"
                         end-evaluate
           end-evaluate
           .

       WIN-EVT.
           if event-type = cmd-close   
              move 1 to close-win
           end-if
           .
